<?php
/* =====================================================
   R2 LOAD BALANCER NODE - PLAY.PHP
   Points to: /var/www/shop1bollydrive
===================================================== */

// 🔥 MAIN ACCOUNT DATA PATH
$BASE_PATH = '/var/www/shop1bollydrive/public_html/new';
$SHARE_DIR = "$BASE_PATH/base/data/main/share";

$id = $_GET['id'] ?? '';
if (!$id || !ctype_alnum($id)) die("Invalid ID");

$jsonFile = "$SHARE_DIR/$id.json";

// 1. Agar Main Account par file nahi mili
if (!file_exists($jsonFile)) {
    die("Video Data Not Found (Main Node)");
}

$data = json_decode(file_get_contents($jsonFile), true);
if (!$data) die("Invalid Data");

// 2. Agar file 'Queued' ya 'Error' hai, toh Worker ko trigger karein
if (($data['r2_status'] ?? '') !== 'ready') {
    
    // Status dikhane ke liye simple text
    if (($data['r2_status'] ?? '') == 'uploading') echo "PROCESSING... (Encoding on Sub-Node)";
    else echo "QUEUED... (Waiting for Worker)";
    
    // Background mein worker start karein (Isi Sub-Account ka CPU use hoga)
    // Yeh command background mein chalegi
    $cmd = "/usr/bin/php " . __DIR__ . "/cron/r2-hls-worker.php > /dev/null 2>&1 &";
    exec($cmd);
    
    exit;
}

// 3. Agar Ready hai, toh Play karein (Last Play Time update karein)
$data['r2_last_play'] = time();
file_put_contents($jsonFile, json_encode($data, JSON_PRETTY_PRINT), LOCK_EX);

// 4. Redirect to R2 URL
header("Location: https://r2.bollydrive.baby/$id/hls/index.m3u8");
exit;
?>